/************************************************************************
* COPYRIGHT:   Copyright    1998 Symbol Technologies, Inc. 
*
* FILE:        ScanMgrStruct.h
*
* SYSTEM:      Symbol barcode scanner for Palm III.
*
* HEADER:      Scan Manager structure definitions
*
* DESCRIPTION: Provides the structure definitions used by the internal
*					functions of the decoder shared library.
*
* HISTORY:     4/13/98    	SS   	Created
*	      	  12/31/00	 	Inv.	Removed PalmCompatibility.h for PalmOS 3.5 conversion
*
*              ...
*************************************************************************/
#pragma once on

#ifdef __cplusplus
   extern "C" {
#endif

// The ScanEvent record.
typedef struct 
{
	eventsEnum     eType;
	Boolean        penDown;
	Int16          screenX;
	Int16          screenY;
	union scanData 
	{
		struct scanGen
		{
			UInt16 data1;		//	Use this variable as flag to tell app if decode data has multiple packets.
			UInt16 data2;		
			UInt16 data3;
			UInt16 data4;
			UInt16 data5;
			UInt16 data6;
			UInt16 data7;
			UInt16 data8;
		} scanGen;

		struct 
		{
			UInt16 batteryLevel;			// The current voltage measured in millivolts
			UInt16 batteryErrorType;		// not used
		} batteryError;

	} scanData;	// End of union
	
} ScanEventType;
typedef ScanEventType *ScanEventPtr;

/*******************************************************************
 *    Message structure used to hold decoder messages              *
 * Used by ScanGetDecodeData to return barcode type and data       *
 *******************************************************************/
#define MAX_PACKET_LENGTH       258   //origin for 1D:  258
typedef struct  tagMESSAGE
{
	Int16 length; // length of the data
	Int16 type;	// contains the barcode type when the msg is DecodeData
	Int16 status; // should be STATUS_OK
	UInt8 data[MAX_PACKET_LENGTH]; // the message data
} MESSAGE;

#define MAX_DCD_LENGTH       3000   //origin for 1D:  258
/*******************************************************************
 *                                               *
 *******************************************************************/

typedef struct  tagMESSAGE_Dcd
{
	Int16 length; // length of the data
	Int16 type;	// contains the barcode type when the msg is DecodeData
	Int16 status; // should be STATUS_OK
	UInt8 data[MAX_DCD_LENGTH]; // the message data
} MESSAGE_Dcd;

/*******************************************************************
 * BATCH structure used to hold all the decoder parameters to be   *
 * sent to the decoder.  Not used by application programmers.      *
 *******************************************************************/
#define MAX_BATCH_PARAM         247
typedef struct tagBATCH
{
	Int16 length;
	Int16 data[MAX_BATCH_PARAM + 3];
} BATCH;

/*******************************************************************
 * Communication structure COMM_STRUCT is used in the Scan Manager *
 * internal code.                                                  *
 * Note that the communications parameters are preset for this     *
 * version of the decoder and need not be changed by applications. *
 *******************************************************************/
typedef struct  tagCOMM_STRUCT
{
	Int16 port;
	Int16 baud;
	Int16 parity;			
	Int16 stop_bits;
	Int16 host_timeout;
} COMM_STRUCT;


#define PACKET_CONTINUATION	0x0002

/*******************************************************************

 * Decoder Parameters                                              *

 *******************************************************************/


#define MAX_DECODER_PARMS       1024


#ifdef __cplusplus
    }
#endif
